import pandas as pd  
import pickle 
from decision_company import read_csv_file, col_copy
  
# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv") 
  
# Extract the important columns  
important_columns = ['credit_history', 'age', 'employment', 'credit_amount', 'savings_status']  
data_for_clustering = col_copy(credit_customers, important_columns)  

print("data_for_clustering:\n", data_for_clustering)    
pickle.dump(data_for_clustering,open("./ref_result/data_for_clustering.pkl","wb"))